################################################################################
#
# grlib
#
################################################################################
GRLIB_DRVPKG_VERSION = $(call qstrip,$(BR2_TARGET_GRLIB_DRVPKG_VERSION))
GRLIB_DRVPKG_COMPR = bz2
GRLIB_DRVPKG_SOURCE = grlib-linux-drvpkg-$(GRLIB_DRVPKG_VERSION).tar.$(GRLIB_DRVPKG_COMPR)
GRLIB_DRVPKG_LICENSE = GPL-2.0+
GRLIB_DRVPKG_DEPENDENCIES=linux

ifeq ($(GRLIB_DRVPKG_VERSION),custom)
# Handle custom GRLIB Linux driver package tarballs as specified by the configuration
GRLIB_DRVPKG_TARBALL = $(call qstrip,$(BR2_TARGET_GRLIB_DRVPKG_CUSTOM_TARBALL_LOCATION))
GRLIB_DRVPKG_SITE = $(patsubst %/,%,$(dir $(GRLIB_DRVPKG_TARBALL)))
GRLIB_DRVPKG_SOURCE = $(notdir $(GRLIB_DRVPKG_TARBALL))
else
GRLIB_DRVPKG_SITE = https://download.gaisler.com/anonftp/linux/linux-5/kernel
endif

ifeq ($(BR2_TARGET_GRLIB_DRVPKG)$(BR2_TARGET_GRLIB_DRVPKG_LATEST_VERSION),y)
BR_NO_CHECK_HASH_FOR += $(GRLIB_DRVPKG_SOURCE)
endif

ifeq ($(BR2_TARGET_GRLIB_DRVPKG_LATEST_VERSION),y)
GRLIB_DRVPKG_LICENSE_FILES = doc/gpl-2.0.txt
endif

GRLIB_EXAMPLES_CFLAGS = $(TARGET_CFLAGS) -I$(LINUX_DIR)/drivers/grlib/include

# Add 4 bytes of extra user data to the SpaceWire packet
GRLIB_GRSPW_EXAMPLES_CFLAGS = $(GRLIB_EXAMPLES_CFLAGS) -DSPWLIB_PKT_EXTRA_DATA=1

# Build all user applications in the driver package
define GRLIB_DRVPKG_BUILD_CMDS
$(if $(filter y, $(BR2_PACKAGE_GRLIB_GRSPW_EXAMPLES)), \
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(@D)/user/grspw_user \
	 CFLAGS="$(GRLIB_GRSPW_EXAMPLES_CFLAGS)" LINUXPATH=$(LINUX_DIR) \
	 CC=$(TARGET_CC) all)

$(if $(filter y, $(BR2_PACKAGE_GRLIB_GRSPWROUTER_EXAMPLES)), \
	$(MAKE) $(TARGET_CONFIGURE_OPTS) -C $(@D)/user/grspw_router \
	 CFLAGS="$(GRLIB_EXAMPLES_CFLAGS)" LINUXPATH=$(LINUX_DIR) CC=$(TARGET_CC) all)
endef

# Install all enabled user applications
define GRLIB_DRVPKG_INSTALL_TARGET_CMDS
$(if $(filter y, $(BR2_PACKAGE_GRLIB_GRSPW_EXAMPLES)), \
	find $(@D)/user/grspw_user -maxdepth 1 -type f -executable \
		-exec $(INSTALL) -m 0755 {} $(TARGET_DIR)/usr/bin/ \;)

$(if $(filter y, $(BR2_PACKAGE_GRLIB_GRSPWROUTER_EXAMPLES)), \
	find $(@D)/user/grspw_router -maxdepth 1 -type f -executable \
		-exec $(INSTALL) -m 0755 {} $(TARGET_DIR)/usr/bin/ \;)
endef

$(eval $(generic-package))
